<?php

defined( 'ABSPATH' ) || die();

class Liquid_Icon_Manager {

    public static function init() {
        add_filter( 'elementor/icons_manager/additional_tabs', [ __CLASS__, 'add_akar_icons' ] );
    }

    public static function add_akar_icons( $tabs ) {

        $icons = array(
			"air",
			"airplay-audio",
			"airplay-video",
			"airpods",
			"alarm",
			"align-bottom",
			"align-horizontal-center",
			"align-left",
			"align-right",
			"align-to-bottom",
			"align-to-middle",
			"align-to-top",
			"align-top",
			"align-vertical-center",
			"android-fill",
			"angular-fill",
			"arrow-back-thick-fill",
			"arrow-back-thick",
			"arrow-back",
			"arrow-clockwise",
			"arrow-counter-clockwise",
			"arrow-cycle",
			"arrow-down-left",
			"arrow-down-right",
			"arrow-down-thick",
			"arrow-down",
			"arrow-forward-thick-fill",
			"arrow-forward-thick",
			"arrow-forward",
			"arrow-left-thick",
			"arrow-left",
			"arrow-repeat",
			"arrow-right-left",
			"arrow-right-thick",
			"arrow-right",
			"arrow-shuffle",
			"arrow-up-down",
			"arrow-up-left",
			"arrow-up-right",
			"arrow-up-thick",
			"arrow-up",
			"ascending",
			"attach",
			"augmented-reality",
			"backspace-fill",
			"backspace",
			"bank",
			"basket",
			"battery-charging",
			"battery-empty",
			"battery-full",
			"battery-low",
			"battery-medium",
			"behance-fill",
			"bell",
			"bicycle",
			"bitcoin-fill",
			"block",
			"bluetooth",
			"boat",
			"book-close",
			"book-open",
			"bootstrap-fill",
			"box",
			"briefcase",
			"bug",
			"cake",
			"calculator",
			"calendar",
			"camera",
			"cart",
			"chat-add",
			"chat-approve",
			"chat-bubble",
			"chat-dots",
			"chat-edit",
			"chat-error",
			"chat-question",
			"chat-remove",
			"check-box-fill",
			"check-box",
			"check-in",
			"check",
			"chess",
			"chevron-down-small",
			"chevron-down",
			"chevron-horizontal",
			"chevron-left-small",
			"chevron-left",
			"chevron-right-small",
			"chevron-right",
			"chevron-up-small",
			"chevron-up",
			"chevron-vertical",
			"circle-alert-fill",
			"circle-alert",
			"circle-check-fill",
			"circle-check",
			"circle-chevron-down-fill",
			"circle-chevron-down",
			"circle-chevron-left-fill",
			"circle-chevron-left",
			"circle-chevron-right-fill",
			"circle-chevron-right",
			"circle-chevron-up-fill",
			"circle-chevron-up",
			"circle-fill",
			"circle-minus-fill",
			"circle-minus",
			"circle-plus-fill",
			"circle-plus",
			"circle-triangle-down-fill",
			"circle-triangle-down",
			"circle-triangle-left-fill",
			"circle-triangle-left",
			"circle-triangle-right-fill",
			"circle-triangle-right",
			"circle-triangle-up-fill",
			"circle-triangle-up",
			"circle-x-fill",
			"circle-x",
			"circle",
			"clipboard",
			"clock",
			"cloud-download",
			"cloud-upload",
			"cloud",
			"codepen-fill",
			"coffee",
			"coin",
			"command",
			"computing",
			"copy",
			"credit-card-alt1",
			"credit-card",
			"cross",
			"crown",
			"css-fill",
			"cursor",
			"cut",
			"dashboard",
			"data",
			"dental",
			"descending",
			"desktop-device",
			"devices",
			"diamond",
			"dice-1",
			"dice-2",
			"dice-3",
			"dice-4",
			"dice-5",
			"dice-6",
			"discord-fill",
			"django-fill",
			"door",
			"dot-grid-fill",
			"double-check",
			"double-sword",
			"download",
			"draft",
			"drag-horizontal-fill",
			"drag-vertical-fill",
			"dribbble-fill",
			"dropbox-fill",
			"edit",
			"enlarge",
			"envelope",
			"equal-fill",
			"equal",
			"eye-closed",
			"eye-open",
			"eye-slashed",
			"face-happy",
			"face-neutral",
			"face-sad",
			"face-very-happy",
			"face-very-sad",
			"face-wink",
			"facebook-fill",
			"figma-fill",
			"file",
			"filter",
			"fire",
			"flag",
			"flashlight",
			"folder-add",
			"folder",
			"fork-left",
			"fork-right",
			"frame",
			"full-screen",
			"game-controller",
			"gatsby-fill",
			"gear",
			"gift",
			"github-fill",
			"glasses",
			"globe",
			"google-contained-fill",
			"google-fill",
			"graphql-fill",
			"grid",
			"hammer",
			"hand",
			"hashtag",
			"headphone",
			"health",
			"heart",
			"height",
			"heptagon-fill",
			"heptagon",
			"hexagon-fill",
			"hexagon",
			"history",
			"home-alt1",
			"home",
			"html-fill",
			"image",
			"inbox",
			"infinite",
			"info-fill",
			"info",
			"instagram-fill",
			"jar",
			"javascript-fill",
			"jquery-fill",
			"key-cap",
			"key",
			"language",
			"laptop-device",
			"leaf",
			"lifesaver",
			"light-bulb",
			"link-chain",
			"link-off",
			"link-on",
			"link-out",
			"linkedin-box-fill",
			"linkedin-fill",
			"location",
			"lock-off",
			"lock-on",
			"map",
			"mastodon-fill",
			"medium-fill",
			"mention",
			"microphone",
			"miniplayer",
			"minus",
			"mobile-device",
			"money",
			"moon-fill",
			"moon",
			"more-horizontal-fill",
			"more-vertical-fill",
			"music-album-fill",
			"music-album",
			"music-note",
			"music",
			"network",
			"newspaper",
			"nextjs-fill",
			"node-fill",
			"normal-screen",
			"npm-fill",
			"octagon-fill",
			"octagon",
			"octocat-fill",
			"open-envelope",
			"oval",
			"panel-bottom",
			"panel-left",
			"panel-right",
			"panel-split-column",
			"panel-split-row",
			"panel-split",
			"panel-top",
			"paper-airplane",
			"paper",
			"parallelogram",
			"pause",
			"pencil",
			"pentagon-fill",
			"pentagon",
			"people-group",
			"people-multiple",
			"percentage",
			"person-add",
			"person-check",
			"person-cross",
			"person",
			"phone",
			"php-fill",
			"pin",
			"pinterest-fill",
			"plane-fill",
			"plane",
			"planet",
			"plant",
			"play",
			"plus",
			"pointer-down-fill",
			"pointer-hand",
			"pointer-left-fill",
			"pointer-right-fill",
			"pointer-up-fill",
			"pointing-up",
			"postgresql-fill",
			"price-cut",
			"product-hunt-fill",
			"python-fill",
			"question-fill",
			"question",
			"radio-fill",
			"radio",
			"radish",
			"react-fill",
			"receipt",
			"reddit-fill",
			"reduce",
			"redux-fill",
			"ribbon",
			"rock-on",
			"rss",
			"sass-fill",
			"save",
			"schedule",
			"scissor",
			"search",
			"send",
			"settings-horizontal",
			"settings-vertical",
			"share-box",
			"shield",
			"shipping-box-v1",
			"shipping-box-v2",
			"shopping-bag",
			"sign-out",
			"slack-fill",
			"slice",
			"snapchat-fill",
			"sort",
			"sound-down",
			"sound-off",
			"sound-on",
			"sound-up",
			"soundcloud-fill",
			"sparkles",
			"spotify-fill",
			"square-fill",
			"square",
			"stack-overflow-fill",
			"star",
			"statistic-down",
			"statistic-up",
			"stop-fill",
			"stop",
			"sun-fill",
			"sun",
			"sword",
			"tablet-device",
			"tag",
			"telegram-fill",
			"telescope",
			"tetragon-fill",
			"tetragon",
			"text-align-center",
			"text-align-justified",
			"text-align-left",
			"text-align-right",
			"threads-fill",
			"three-line-horizontal",
			"three-line-vertical",
			"thumbs-down",
			"thumbs-up",
			"thunder",
			"ticket",
			"tiktok-fill",
			"toggle-off-fill",
			"toggle-off",
			"toggle-on-fill",
			"toggle-on",
			"togo-cup",
			"trash-bin",
			"trash-can",
			"triangle-alert-fill",
			"triangle-alert",
			"triangle-down-fill",
			"triangle-down",
			"triangle-fill",
			"triangle-left-fill",
			"triangle-left",
			"triangle-right-fill",
			"triangle-right",
			"triangle-up-fill",
			"triangle-up",
			"triangle",
			"trophy",
			"truck",
			"tumblr-fill",
			"twitch-fill",
			"twitter-fill",
			"two-line-horizontal",
			"two-line-vertical",
			"typescript-fill",
			"umbrella",
			"unsplash-fill",
			"utensils",
			"vape-kit",
			"vercel-fill",
			"victory-hand",
			"video",
			"vimeo-fill",
			"vk-fill",
			"vr-ar",
			"vscode-fill",
			"vue-fill",
			"wallet",
			"watch-device",
			"water",
			"whatsapp-fill",
			"width",
			"wifi",
			"wine-glass",
			"x-fill",
			"x-small",
			"yarn-fill",
			"yelp-fill",
			"youtube-fill",
			"zoom-fill",
			"zoom-in",
			"zoom-out",
        );
        
        $tabs['akar-icons'] = array(
            'name'          => 'akar-icons',
            'label'         => esc_html__( 'Akar Icons', 'logistics-hub-core' ),
            'labelIcon'     => 'akar-icons ai-water',
            'prefix'        => 'ai-',
            'displayPrefix' => 'akar-icons',
            'url'           => get_template_directory_uri() . '/liquid/extensions/menu-icons/vendor/codeinwp/icon-picker/css/types/akar-icons.min.css',
            'icons'         => $icons,
            'ver'           => '1.1.21',
        );
        return $tabs;
    }

}

Liquid_Icon_Manager::init();